@include('layout.headerfront')
<?php
use App\General;
use App\Details; ?>
<main id="page-content" class="main-container">
    <div class="breadcrums">
        <div class="container">
            <div class="breadcrumb-area" id="breadcrumbArea">
                <ol class="breadcrumb breadcrumb_style">
                    <li><i class="fa fa-home" aria-hidden="true"></i><a href="{{url('/')}}" class="sliding-u-l-r-l">Home</a></li>
                    <li class="">Catalogues</li><li class="active">{{$Types}}</li> 
                </ol>
            </div>
            @include('front.search')

        </div>
    </div>
    <div class="container">
        <section class="content mt40">  
            @include('layout.sidebar')
            <div class="col-sm-9 right-panel">
                <div class="top-panel"> 
                    <div class="sort-area">
                        Sort By:   
                        <select onchange="SearchUrl('sort', this.value);"  name="sort" id="sort" >
                            <option value="">Default sorting </option>
                            <option value="asc">Name Asc</option>
                            <option value="desc">Name Desc</option>
                            <option value="pasc">Price: Low to High</option>
                            <option value="pdesc">Price: High to Low</option>
                        </select> 
                        <span class="pull-right" id="showing">Showing {{$productslist->firstItem()}} - {{$productslist->lastItem()}} of {{$productslist->total()}} results</span> 
                    </div>
                </div>
                <div class="mid-panel">
                    <div class="filter-area show-filter" id="show_filter">
                    </div>
                </div>
                <div id="load"></div>
                <div id="search-result">   
                    @include('front.result')
                </div>
            </div> 
        </section>
    </div>
     <?php
     
     $price_limit = General::getPriceLimit($Types);
     
     if($price_limit['s_max'] >= $price_limit['ys_max']){
         $max_price=round($price_limit['s_max']);
     }
     if($price_limit['ys_max'] >= $price_limit['s_max']){
         $max_price=round($price_limit['ys_max']);
     }
     
     if($price_limit['s_min'] >= $price_limit['ys_min']){
         $min_price=round($price_limit['s_min']);
     }
     if($price_limit['ys_min'] >= $price_limit['s_min']){
         $min_price=round($price_limit['ys_min']);
     }
     
    
     if (Auth::guest()){
                    $min =$min_price;
                       $max =$max_price;
                    } else { 
                    if (Auth::user()->active==1){
                    
                    $per = Auth::user()->markup_per;
                    $amount = Auth::user()->markup_amount;
                    $min =General::getMarkup($per,$amount,$min_price);
                    $max =General::getMarkup($per,$amount,$max_price);
                    $min =round($min);
                    $max =round($max);
                       ?>
                           <script>
            $(function () {
                $("#slider-range").slider({
                    range: true,
                    step: 0.25,
                    min:  <?php echo $min;?>,
                    max: <?php echo $max;?>,
                    values: [<?php echo $min;?>, <?php echo $max;?>],
                    slide: function (event, ui) {
                        $("#amount").val("$" + ui.values[ 0 ] + "-$" + ui.values[ 1 ]);
                    },
                    stop: function (event, ui) {
                        $("#amount").text(ui.values[0] + "-" + ui.values[1]);
                        //SearchUrl("price_min",ui.values[0]);
                        $("#p_min").val(ui.values[0]);
                        $("#p_max").val(ui.values[1]);
                        $("#amount").text("R$" + $("#slider-range").slider("values", 0) + "-R$" + $("#slider-range").slider("values", 1));
                        RSearchUrl("p_min", ui.values[0], "p_max", ui.values[1]);
                    }
                });
                // $("#amount").val("$" + $("#slider-range").slider("values", 0) + " - $" + $("#slider-range").slider("values", 1));

            });
    </script>
                           <?php
                    } 
                    
                    } ?>
    
    <script type="text/javascript">
        function searchPagination(value)
        {
            var originalURL = "<?php echo (Request::getQueryString() ? ( Request::getQueryString()) : ''); ?>";
            //alert(originalURL);
            var checkboxes = $('.all input[type="checkbox"]');
            var url = removeParam('page', originalURL, value);
            
            var price=$("#amount").val();
            if(price){
                var res = price.split("-");
                var res1 = res[0].replace("$", "");
                var res2 = res[1].replace("$", "");
                var prices = "&p_min="+res1+"&p_max="+res2;
            } else {
                var prices ='';
            }
            var sort=$("#sort").val();
            if(sort){
                var res = sort.split("-");
                var sorts = "&sort="+sort;
            } else {
                var sorts ='';
            }
            var search = originalURL +sorts+ prices+"&page=" + value + "&" + checkboxes.serialize();
            SearchResult(search);
        }
        $(function () {
            $('body').on('click', '.pagination a', function (e) {
                e.preventDefault();

                var url = $(this).attr('href');
                var getval = url.split('=');
                var value = getval[1];
                $("html, body").animate({scrollTop: 0}, "slow");
                //SearchUrl('page',value);
                searchPagination(value);
                return false;

                //window.history.pushState("", "", url);
            });

        });

    </script>
 
   
    @include('layout.jquery')
    @include('layout.footer')

