<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/
Route::get('/products/{type}', 'HomeController@productlist');
Route::get('/detail/{stylenum}', 'HomeController@Details');
Route::get('/search', 'HomeController@Search');
Route::post('/subscribe', 'HomeController@Subscribe');

//Route::get('/products', 'HomeController@productlist');
Route::get('/result', 'HomeController@result');

Route::get('/getimage', 'HomeController@getImage');

Route::get('/', 'HomeController@Home');
Route::get('home', 'HomeController@Home');
Route::auth();

Route::get('admin', function () {
    return view('register');
});

Route::get('welcome', function () {
    return view('front.welcome');
});

Route::controllers(['auth' => 'Auth\AuthController', 'password' => 'Auth\PasswordController',]);

Route::post('login','MainController@login');

Route::get('login', function () {
    return redirect('register');
});

Route::get('register', function () {
    return view('register');
});

Route::post('registeruser','MainController@register');

Route::get('/home', 'HomeController@index');

Route::get('viewuser',function(){
   return view('admin.viewusers');
});

Route::get('adminindex','AdminController@adminindex');

// Group Route try

Route::group(
    array('prefix' => 'admin'), 
    function() {
        $admin= "Admin\\";
        
        Route::get('dashboard','AdminController@adminindex');
		Route::get('request','AdminController@requestapp');
        //users
         Route::get('show_users','AdminController@showAllUsers');
         Route::get('deleteUser/{id}','AdminController@deleteUser');
         Route::get('editUser/{id}','AdminController@editUser');
         Route::post('edit_user_action','AdminController@editUserAction');
         Route::get('activeUser/{id}','AdminController@activeUser');
         Route::get('blockUser/{id}','AdminController@blockUser');
         
         // supplier Information
         
         Route::get('supplierLocationScreen','SupplierController@supplierLocationScreen');
         Route::get('searchCategory/{name}','SupplierController@searchCategory');
         Route::post('supplierLocationAction','SupplierController@supplierLocationAction');

    }
);
